
from django.conf import settings

from plan.api.idm import helpers
from plan.api.idm.hooks import Hooks as AbcHooks

from plan.services.models import ServiceTag


class Hooks(AbcHooks):

    GET_ROLES_STREAMS = [helpers.InternalAccessRolesStream, helpers.ServiceTagPermissionsStream]
    INTERNAL_ROLES_SOURCE = settings.ABC_INTERNAL_ACCESS_ROLES

    def info(self):
        return {
            'code': 0,
            'roles': {
                'slug': 'type',
                'name': {
                    'ru': 'Типы ролей',
                    'en': 'Role types',
                },
                'values': {
                    'internal': {
                        'name': {
                            'ru': 'Роли ABC',
                            'en': 'ABC internal roles',
                        },
                        'roles': {
                            'slug': 'internal_key',
                            'name': {
                                'ru': 'Роли',
                                'en': 'Roles',
                            },
                            'values': self.internal_roles(),
                        }
                    },
                    'service_tags': {
                        'name': {
                            'ru': 'Роли на теги',
                            'en': 'ABC tag roles',
                        },
                        'roles': {
                            'slug': 'service_tags_key',
                            'name': {
                                'ru': 'Теги сервисов',
                                'en': 'Service tags',
                            },
                            'values': self.service_tags(),
                        },
                    },
                }
            }
        }

    def service_tags(self):
        tree = {}
        for tag in ServiceTag.objects.exclude(is_protected=True):
            tree[tag.slug] = {
                'name': {'ru': tag.name, 'en': tag.name_en},
                'help': {'ru': tag.description, 'en': tag.description_en},
            }
        return tree
