from django import forms
from django.utils.translation import ugettext_lazy as _

from plan.staff.models import Department, Staff


class NoValidationField(forms.Field):
    def clean(self, value):
        return value


class BetterErrorMixin(object):
    """Миксин позволяющей пробрасывать в сообщение об ошибке
    проверяемое невалидное значение"""

    def to_python(self, value):
        try:
            result = super(BetterErrorMixin, self).to_python(value)
        except forms.ValidationError as exc:
            exc.params = {'value': value}
            raise exc
        return result


class GroupField(BetterErrorMixin, forms.ModelChoiceField):
    def __init__(self, **kwargs):
        defaults = {
            'queryset': Department.objects.all(),
            'to_field_name': 'staff_id',
            'error_messages': {
                'invalid_choice': _(
                    'Роль может быть запрошена только на департаментную группу. '
                    'Департаментная группа с id=%(value)s не найдена'
                )
            }
        }
        defaults.update(kwargs)
        super(GroupField, self).__init__(**defaults)


class UserField(BetterErrorMixin, forms.ModelChoiceField):
    def __init__(self, **kwargs):
        defaults = {
            'queryset': Staff.objects.all(),
            'to_field_name': 'login',
            'error_messages': {
                'invalid_choice': _('Пользователь %(value)s не найден')
            }
        }
        defaults.update(kwargs)
        super(UserField, self).__init__(**defaults)
