from django.conf import settings
from rest_framework import routers

from plan.assessors.api.views import (
    PermissiveDepartmentsView, PermissiveV4DepartmentsView,
    PermissiveV3MembersView, PermissiveV4MembersView,
    PermissiveFrontendDepartmentsView,
    PermissiveFrontendMembersView,
)
from plan.api.views import NotifierView, V4NotifierView, FrontendPermissionsView
from plan.api.intranet.persons import PersonView, V4PersonView
from plan.api.suggests.services.views import FrontendSuggestServicesView
from plan.duty.api.views import FrontendScheduleView

from plan.holidays.api.views import HolidayView
from plan.history.api.views import HistoryEntryViewSet

from plan.duty.api import views as dutyviews
from plan.services.api.creates import CreateRequestsView
from plan.services.api.moves import V4MovesView, FrontendMovesView
from plan.services.api.contacts import ContactsView, V4ContactsView
from plan.services.api.departments import (
    DepartmentsView,
    V4DepartmentsView,
    FrontendDepartmentsView,
)
from plan.services.api.members import V3MembersView, V4MembersView
from plan.services.api.parent import ParentView
from plan.services.api.responsibles import V3ResponsiblesView, V4ResponsiblesView
from plan.services.api.services import (
    ServicesView,
    V4ServicesView,
    ScopeCounterView,
    FrontendPuncherRules,
    FrontendIDMRoles,
)
from plan.services.api.gradient import V4GradientView
from plan.services.api.frontend import (
    FrontendServicesView,
    FrontendContactsView,
    FrontendContactsTypeView,
    FrontendResponsibleView,
    FrontendMembersView,
    FrontendServiceExportView,
)
from plan.services.api.slug import MakeSlugView, ValidateSlugView
from plan.services.api.tags import ValidateTagsView
from plan.services.api.team_statuses import TeamStatusesView

from plan.roles.api.roles import RolesView, V4RolesView
from plan.roles.api.rolescopes import RoleScopesView, V4RoleScopesView

from plan.resources.api.financial import V4FinancialResourceRequestView
from plan.resources.api.resource_tag_categories import ResourceTagCategoryView, V4ResourceTagCategoryView
from plan.resources.api.resource_tags import ResourceTagView, V4ResourceTagView
from plan.resources.api.resource_type_categories import ResourceTypeCategoryView, V4ResourceTypeCategoryView
from plan.resources.api.resource_types import ResourceTypesView, V4ResourceTypesView
from plan.resources.api.resources import ResourcesView, V4ResourcesView
from plan.resources.api.service_resources import (
    V3ServiceResourcesView,
    V4ServiceResourcesView,
    FrontendServiceResourcesView,
    GDRPServiceResourceExportView,
    InfrastructureFrontendView,
)
from plan.resources.api.constructor import ConstructorFormView, V4ConstructorFormView
from plan.services.api.team import TeamView
from plan.resources.api.counter import ServiceResourceCounterView

from plan.oebs.api.views import (
    OEBSAgreementView,
    OEBSRespondView,
    OEBSTreeView,
    V4OEBSAgreementView,
    OEBSDeviationView,
)

from plan.staff.api.views import StaffDepartmentsView, StaffPersonView

from plan.suspicion.api.views import (
    ComplaintView, V4ComplaintView,
    ServiceAppealIssueView, V4ServiceAppealIssueView,
    ServiceIssueView,
)

router = routers.DefaultRouter()
v4_router = routers.DefaultRouter()
frontend_router = routers.DefaultRouter()

if settings.CROWDTEST:
    router.register(r'services/departments', PermissiveDepartmentsView, basename='service-department')
    router.register(r'services/members', PermissiveV3MembersView, basename='service-member')
    v4_router.register(r'services/departments', PermissiveV4DepartmentsView, basename='service-department')
    v4_router.register(r'services/members', PermissiveV4MembersView, basename='service-member')
    frontend_router.register(r'services/departments', PermissiveFrontendDepartmentsView, basename='service-department')
    frontend_router.register(r'services/members', PermissiveFrontendMembersView, basename='service-member')
else:
    router.register(r'services/departments', DepartmentsView, basename='service-department')
    router.register(r'services/members', V3MembersView, basename='service-member')
    v4_router.register(r'services/departments', V4DepartmentsView, basename='service-department')
    v4_router.register(r'services/members', V4MembersView, basename='service-member')
    frontend_router.register(r'services/departments', FrontendDepartmentsView, basename='service-department')
    frontend_router.register(r'services/members', FrontendMembersView, basename='service-member')

router.register(r'intranet/persons', PersonView, basename='intranet-person')

router.register(r'duty/schedules', dutyviews.ScheduleView, basename='duty-schedule')
router.register(r'duty/gaps', dutyviews.GapsView, basename='duty-gap')
router.register(r'duty/shifts', dutyviews.ShiftView, basename='duty-shift')
router.register(r'duty/allowforduty', dutyviews.AllowForDutyView, basename='allowforduty')

router.register(r'notifier', NotifierView, basename='notifier')

router.register(r'services/contacts', ContactsView, basename='service-contact')
router.register(r'services/responsibles', V3ResponsiblesView, basename='service-responsible')
router.register(r'services', ServicesView, basename='service')

router.register(r'roles/scopes', RoleScopesView, basename='role-scope')
router.register(r'roles', RolesView, basename='role')

router.register(r'resources/types/categories', ResourceTypeCategoryView, basename='resource-type-category')
router.register(r'resources/types', ResourceTypesView, basename='resource-types')
router.register(r'resources/tags/categories', ResourceTagCategoryView, basename='resource-tag-category')
router.register(r'resources/tags', ResourceTagView, basename='resource-tag')
router.register(r'resources/consumers', V3ServiceResourcesView, basename='resource-consumer')
router.register(r'resources/request', ConstructorFormView, basename='resource-request')
router.register(r'resources', ResourcesView, basename='resource')
router.register(r'suspicion/complaints', ComplaintView, basename='complaint')
router.register(r'suspicion/appeals', ServiceAppealIssueView, basename='appeal')


v4_router.register(r'intranet/persons', V4PersonView, basename='intranet-person')

v4_router.register(r'duty/schedules', dutyviews.V4ScheduleView, basename='duty-schedule')
v4_router.register(r'duty/schedules-cursor', dutyviews.V4ScheduleCursorView, basename='duty-schedule-cursor')
v4_router.register(r'duty/gaps', dutyviews.V4GapsView, basename='duty-gap')
v4_router.register(r'duty/shifts', dutyviews.V4ShiftView, basename='duty-shift')
v4_router.register(r'duty/allowforduty', dutyviews.V4AllowForDutyView, basename='allowforduty')
v4_router.register(r'duty/on_duty', dutyviews.V4OnDutyView, basename='duty-on-duty')
v4_router.register(r'duty/abc_to_watcher', dutyviews.V4DutyToWatcherView, basename='duty-abc-to-watcher')

v4_router.register(r'suspicion/complaints', V4ComplaintView, basename='complaint')
v4_router.register(r'suspicion/appeals', V4ServiceAppealIssueView, basename='appeal')
v4_router.register(r'suspicion/issues', ServiceIssueView, basename='issue')
v4_router.register(r'notifier', V4NotifierView, basename='notifier')    # если фронт на ручке фронтенд  - удалить

v4_router.register(r'services/contacts', V4ContactsView, basename='service-contact')
v4_router.register(r'services/gradient', V4GradientView, basename='service-gradient')
v4_router.register(r'services/responsibles', V4ResponsiblesView, basename='service-responsible')
v4_router.register(r'services/move-requests', V4MovesView, basename='moves')
v4_router.register(r'services', V4ServicesView, basename='service')

v4_router.register(r'roles/scopes', V4RoleScopesView, basename='role-scope')
v4_router.register(r'roles', V4RolesView, basename='role')

v4_router.register(r'resources/financial_resources', V4FinancialResourceRequestView, basename='financial-resources')
v4_router.register(r'resources/types/categories', V4ResourceTypeCategoryView, basename='resource-type-category')
v4_router.register(r'resources/types', V4ResourceTypesView, basename='resource-types')
v4_router.register(r'resources/tags/categories', V4ResourceTagCategoryView, basename='resource-tag-category')
v4_router.register(r'resources/tags', V4ResourceTagView, basename='resource-tag')
v4_router.register(r'resources/consumers', V4ServiceResourcesView, basename='resource-consumer')
v4_router.register(r'resources/request', V4ConstructorFormView, basename='resource-request')
v4_router.register(r'resources', V4ResourcesView, basename='resource')
v4_router.register(r'oebs/agreements', V4OEBSAgreementView, basename='oebs-agreement')
v4_router.register(r'oebs/respond', OEBSRespondView, basename='oebs-respond')
v4_router.register(r'oebs/deviation', OEBSDeviationView, basename='oebs-deviation')
v4_router.register(r'history', HistoryEntryViewSet, basename='history')
v4_router.register(r'staff', StaffPersonView, 'staff-person')

frontend_router.register(r'oebs/agreements', OEBSAgreementView, basename='oebs-agreement')
frontend_router.register(r'oebs/tree', OEBSTreeView, basename='oebs-tree')
frontend_router.register(r'services_export', FrontendServiceExportView, basename='services-export')
frontend_router.register(r'services/contacts_types', FrontendContactsTypeView, basename='service-contact-type')
frontend_router.register(r'services/create-requests', CreateRequestsView, basename='creates')
frontend_router.register(r'services/move-requests', FrontendMovesView, basename='moves')
frontend_router.register(r'services/team_statuses', TeamStatusesView, basename='service-team-statuses')
frontend_router.register(r'services/make_slug', MakeSlugView, basename='service-make-slug')
frontend_router.register(r'services/contacts', FrontendContactsView, basename='service-contact')
frontend_router.register(r'services/validate_slug', ValidateSlugView, basename='service-validate-slug')
frontend_router.register(r'services/validate_tags', ValidateTagsView, basename='service-validate-tags')
frontend_router.register(r'services/team', TeamView, basename='service-team')
frontend_router.register(r'services/parent', ParentView, basename='service-parent')
frontend_router.register(r'services/responsibles', FrontendResponsibleView, basename='service-responsible')
frontend_router.register(r'services', FrontendServicesView, basename='service')
frontend_router.register(r'suggest/service', FrontendSuggestServicesView, basename='suggest-service')
frontend_router.register(r'permissions', FrontendPermissionsView, basename='permission')
frontend_router.register(r'holidays', HolidayView, basename='holidays')
frontend_router.register(r'departments', StaffDepartmentsView, basename='staff-department')
frontend_router.register(r'duty/schedules', FrontendScheduleView, basename='schedule')
frontend_router.register(r'resources/counter', ServiceResourceCounterView, basename='resources-counter')
frontend_router.register(r'resources/gdpr/export', GDRPServiceResourceExportView, basename='gdpr-export')
frontend_router.register(r'notifier', V4NotifierView, basename='notifier')
frontend_router.register(r'resources/consumers', FrontendServiceResourcesView, basename='resource-consumer')
frontend_router.register(r'resources/infrastructure', InfrastructureFrontendView, basename='infrastructure')
frontend_router.register(r'scopes/counter', ScopeCounterView, basename='scope-counter')
frontend_router.register(r'access/puncher', FrontendPuncherRules, basename='puncher-rules')
frontend_router.register(r'access/idm', FrontendIDMRoles, basename='idm-roles')
