from rest_framework.mixins import ListModelMixin


class SuggestMixin(ListModelMixin):
    def list(self, request, *args, **kwargs):
        lang = self.request.query_params.get('lang', 'ru')
        if lang != 'ru' and self.ordering:
            self.ordering = [x + '_en' for x in self.ordering]

        return super(SuggestMixin, self).list(request, *args, **kwargs)
