from collections import OrderedDict

from rest_framework.pagination import LimitOffsetPagination
from rest_framework.response import Response


class SuggestPagination(LimitOffsetPagination):
    default_limit = 10

    # Не делаем COUNT
    def paginate_queryset(self, queryset, request, view=None):
        self.limit = self.get_limit(request)
        if self.limit is None:
            return None

        self.offset = self.get_offset(request)
        self.request = request
        return list(queryset[self.offset: self.offset + self.limit])

    # Выводим переданные limit, offset вместо ссылок next/prev
    def get_paginated_response(self, data):
        return Response(OrderedDict([
            ('limit', self.limit),
            ('offset', self.offset),
            ('results', data)
        ]))
