from rest_framework import serializers

from plan.api.base import CompactStaffSerializer
from plan.duty.models import Schedule
from plan.staff.models import Staff


class StaffSuggestSerializer(CompactStaffSerializer):
    _type = serializers.SerializerMethodField()

    def get__type(self, obj):
        return 'person'

    class Meta:
        model = Staff
        fields = CompactStaffSerializer.Meta.fields + ['_type']


class PersonSuggestForm(serializers.Serializer):
    schedule = serializers.PrimaryKeyRelatedField(
        queryset=Schedule.objects.all(),
        required=False,
    )
