from django.contrib import admin

from plan.common.base_admin import ViewModelAdmin
from plan.staff.models import Department, Staff


@admin.register(Staff)
class StaffAdmin(ViewModelAdmin):
    list_display = ('login', 'first_name', 'last_name', 'is_dismissed')
    search_fields = ('login', 'first_name', 'last_name')
    list_filter = ('is_dismissed',)


@admin.register(Department)
class DepartmentAdmin(ViewModelAdmin):
    list_display = ('name', 'url')
    search_fields = ('name', 'url')
