from django.db.models.query import BaseIterable


class NestedValuesIterable(BaseIterable):
    @staticmethod
    def make_serialized_row(names, line):
        result = {}
        for keys, value in zip(names, line):
            item = result
            prev = None
            for key in keys:
                if key not in item:
                    item[key] = {}
                prev, item = item, item[key]
            prev[key] = value
        return result

    def __iter__(self):
        queryset = self.queryset
        query = queryset.query
        compiler = query.get_compiler(queryset.db)

        field_names = list(query.values_select)

        names = [x.split('__') for x in field_names]
        make_serialized_row = self.make_serialized_row
        for line in compiler.results_iter():
            yield make_serialized_row(names, line)


class NestedValuesMixin(object):
    def nested_values(self, *fields):
        clone = self._values(*fields)
        clone._iterable_class = NestedValuesIterable
        clone._true_query = self
        return clone
