import collections.abc

from django.conf import settings
from django.utils.translation import ugettext_lazy as _

from plan.hacks.context_processors import werewolf_context


def get_prefixed_context(context, prefix):
    prefixed_ctx = {}
    for i, ctx in enumerate(context):
        prefixed_ctx_part = {f'{prefix}-{i}-{key}': value for key, value in ctx.items()}
        prefixed_ctx.update(prefixed_ctx_part)
    return prefixed_ctx


def join_contexts(exc_ctxs):
    context = {}
    for c in exc_ctxs:
        ctx = c.get('context', None)
        if isinstance(ctx, collections.abc.Mapping):
            context.update(ctx)

    return {
        'code': [c['code'] for c in exc_ctxs],
        'text_message': [c['text_message'] for c in exc_ctxs],
        'context': context,
    }


def common_request_free_context():
    context = {
        'abc_host': settings.ABC_HOST,
        'abc_protocol': settings.ABC_PROTOCOL,

        'occupancy_host': settings.OCCUPANCY_HOST,
        'occupancy_protocol': settings.OCCUPANCY_PROTOCOL,

        'staff_host': settings.STAFF_HOST,
        'staff_protocol': settings.STAFF_PROTOCOL,

        'metrika_id': settings.METRIKA_ID,
    }

    context.update({
        'abc_url': settings.ABC_URL,
        'occupancy_url': settings.OCCUPANCY_URL,
        'staff_url': settings.STAFF_URL,
    })

    return context


def common_context(request):
    staff_or_nil = None
    if request.user.is_authenticated():
        staff_or_nil = request.user.staff
    context = common_request_free_context()
    context.update({
        'request_staff': staff_or_nil,
        'timezone': getattr(staff_or_nil, 'tz', None),
        'debug': settings.DEBUG,
        'readonly': {
            'status': getattr(request, 'service_is_readonly', False),
            'text': str(_('Сервис доступен только для чтения. Приносим извинения за неудобства.')),
        }
    })

    context.update(werewolf_context(request))

    return context
