import json

from django.db import models


class JSONField(models.TextField):
    """ Поле для хранения данных, сериализованных в JSON. """

    editable = False
    serialize = False

    class JSONDict(dict):
        def __str__(self):
            return json.dumps(self, sort_keys=True)

    class JSONList(list):
        def __str__(self):
            return json.dumps(self, sort_keys=True)

    def get_prep_value(self, value):
        return json.dumps(value, sort_keys=True) if value is not None else '{}'

    def from_db_value(self, value, *args, **kwargs):
        return self.to_python(value)

    def to_python(self, value):
        if value is None:
            return value
        elif not isinstance(value, str):
            return value
        if value:
            value = json.loads(value)
            if isinstance(value, list):
                value = self.JSONList(value)
            elif isinstance(value, dict):
                value = self.JSONDict(value)
            return value
        return None
