from django.conf import settings

from requests.sessions import Session as BaseSession
from requests.adapters import HTTPAdapter

from urllib3.util.retry import Retry


class Session(BaseSession):
    def __init__(
            self,
            oauth_token=None,
            retry=None,
            verify=None,
            headers=None,
            connect_retries=None,
            read_retries=None
    ):
        super(Session, self).__init__()

        if verify is None:
            verify = settings.ABC_CA_ROOT_PATH

        self.verify = verify

        if oauth_token is not None:
            self.headers.update({'Authorization': 'OAuth %s' % oauth_token})

        if headers is not None:
            self.headers.update(headers)

        if connect_retries is None:
            connect_retries = settings.DEFAULT_CONNECT_RETRIES

        if read_retries is None:
            read_retries = settings.DEFAULT_READ_RETRIES

        if retry is None:
            retry = Retry(
                connect=connect_retries,
                read=read_retries,
                backoff_factor=settings.DEFAULT_BACKOFF_FACTOR,
                redirect=0,
                raise_on_status=True,
                raise_on_redirect=True,
                status_forcelist=settings.DEFAULT_STATUS_FORCELIST,
            )

        adapter = HTTPAdapter(max_retries=retry)
        self.mount('http://', adapter)
        self.mount('https://', adapter)
