import functools

from django.utils.translation import get_language, activate

from plan import settings


def restore_language(f):
    """
    Если функция вызывает translation.activate, её можно завернуть
    в этот декоратор, который восстановит перевод.
    """
    @functools.wraps(f)
    def wrapper(*args, **kwargs):
        saved_language = get_language()
        try:
            return f(*args, **kwargs)
        finally:
            activate(saved_language)
    return wrapper


@restore_language
def get_translation(string, lang):
    activate(lang)
    return str(string)


def get_default_language():
    return settings.LANGUAGE_CODE.split('_')[0]
