"""
Это модуль про структуру подразделений.
"""


from django.db.models import Q


def get_members_query(department, with_nested=False):
    """
    Получить Q-запрос для фильтрации сотрудников, в подразделении department.
    @param with_nested: включая вложенные подразделения или нет.
    @return: Q
    """
    query = Q(is_dismissed=False)
    if with_nested:
        return query & _get_all_members_query(department)
    else:
        return query & _get_direct_members_query(department)


def _get_all_members_query(department):
    """
    Получить Q-запрос для фильтрации сотрудников подразделения со вложенными.
    :return: Q for Staff
    """
    return Q(department__in=department.get_descendants(include_self=True))


def _get_direct_members_query(department):
    """
    Получить Q-запрос для фильтрации сотрудников подразделения без вложенных.
    :return: Q for Staff
    """
    return Q(department=department)
