"""
Это файл про руководителей/заместителей в структуре подразделений.
"""


from django.db.models import Q

from plan.staff.constants import DEPARTMENT_ROLES
from plan.staff.models import DepartmentStaff


def is_superior_of_person(possible_boss, person):
    if possible_boss == person:
        return False
    return (
        DepartmentStaff.objects
        .filter(
            department_id__in=person.department.get_ancestors(include_self=True).values_list('id', flat=True),
            staff_id=possible_boss.id,
            role=DEPARTMENT_ROLES.CHIEF,
        ).exists()
    )


def get_superior_of_person(person):
    q_departments = Q(department_id__in=person.department.get_ancestors(include_self=True).values_list('id', flat=True))

    query = DepartmentStaff.objects.filter(q_departments)
    query = query.filter(role=DEPARTMENT_ROLES.CHIEF)
    query = query.exclude(staff=person)
    query = query.order_by('-department__level', '-department__id')

    try:
        return query[0].staff
    except IndexError:
        return
