def get_chunks(iterable, size=1):
    """
    Разбивает iterable на группы по size элементов в каждом.
    Если длина iterable не кратна size,
    то длина последнего куска будет меньше size.
    >>> list(get_chunks(range(8), 4))
    [[0, 1, 2, 3], [4, 5, 6, 7]]
    >>> list(get_chunks(range(8), 3))
    [[0, 1, 2], [3, 4, 5], [6, 7]]
    """
    for i in range(0, len(iterable), size):
        yield iterable[i:i + size]
