import json

from django.contrib import messages


class UserMessage(object):

    INFO = messages.INFO
    ERROR = messages.ERROR
    WARNING = messages.WARNING

    def __init__(self, text, level=None, context=None):
        self.level = level if level is not None else UserMessage.INFO
        self.text = text
        self.context = context

    def get_serializable(self):
        context = {
            'level': self.level,
            'text': self.text,
        }
        if self.context is not None:
            context['context'] = self.context
        return context


def feed_messages(request, results):
    for result in filter_messages(results):
        messages.add_message(request, result.level, result.text)


def filter_messages(results):
    return (result for result in results if isinstance(result, UserMessage))


class AjaxMessaging(object):
    def process_response(self, request, response):
        if request.is_ajax():
            content_type = response['Content-Type'].split(';')[0].strip()
            if content_type in ["application/javascript", "application/json"]:
                try:
                    content = json.loads(response.content)
                except ValueError:
                    return response

                django_messages = []

                for message in messages.get_messages(request):
                    django_messages.append({
                        "level": str(message.level),
                        "message": str(message.message),
                        "extra_tags": str(message.tags),
                    })

                if isinstance(content, dict):
                    content['__messages__'] = django_messages

                response.content = json.dumps(content, ensure_ascii=False)
        return response
