import os
import logging

from django.conf import settings as django_settings
from ids.helpers.oauth import get_token

from plan import settings
from plan.staff.models import Staff
from plan.common.utils.tvm import get_tvm_ticket

logger = logging.getLogger(__name__)


def _get_uid_from_bb(login):
    import blackbox
    blackbox.BLACKBOX_URL = 'http://blackbox.yandex-team.ru/blackbox'
    return blackbox.uid(login)


def get_user_ticket_by_oauth(token):
    import blackbox
    blackbox.BLACKBOX_URL = 'http://blackbox.yandex-team.ru/blackbox'
    response = blackbox.oauth(
        token,
        by_token=True,
        get_user_ticket='yes',
        headers={
            'X-Ya-Service-Ticket': get_tvm_ticket(django_settings.TVM2_BLACKBOX_CLIENT.value)
        },
        userip=os.getenv('DEPLOY_POD_IP_0_ADDRESS'),
    )
    user_ticket = response.get('user_ticket')
    if not user_ticket:
        logger.error('Doesn\'t get user_ticket by oauth_token')
    return user_ticket


def _get_uid(person):
    uid = person.uid
    if uid is None:
        uid = _get_uid_from_bb(person.login)
        person.uid = uid
        person.save(force_update=True)

    return uid


def get_abc_zombik():
    return Staff.objects.get(login=settings.ABC_ZOMBIK_LOGIN)


def get_token_for_person(person):
    return get_token(
        uid=_get_uid(person),
        oauth_id=settings.OAUTH_ID,
        oauth_secret=settings.OAUTH_SECRET,
    )


def get_token_for_zombie():
    return settings.OAUTH_ROBOT_TOKEN
