from django.utils.encoding import force_text
from django.views.generic import View
from django.utils.translation import ugettext_lazy as _

from plan.lib.views.mixins import JSONResponseMixin, StdCtxMixin


def get_readonly_context():
    return {
        'id': 'readOnly',
        'text': force_text(_('Сервис доступен только для чтения. Приносим извинения за неудобства.')),
    }


def add_readonly_context(request, context):
    if getattr(request, 'service_is_readonly', False):
        readonly_context = get_readonly_context()
        if 'messages' in context:
            context['messages'].append(readonly_context)
        else:
            context['messages'] = [readonly_context]


class ReadonlyView(JSONResponseMixin, StdCtxMixin, View):
    def get(self, request):
        return self.render_std_response()
