import functools

import waffle
from django.conf import settings
from django.http import HttpResponse


def updates_on_success(code_test=lambda code: 200 <= code < 300):
    """
    К ответу вьюхи с этим декоратором добавляется кука just_updated,
    если код этого ответа удовлетворяет условию лямбды code_test.
    """
    def decorator(f):
        @functools.wraps(f)
        def wrapper(*args, **kwargs):
            from django_replicated.utils import routers
            result = f(*args, **kwargs)

            if (isinstance(result, HttpResponse) and routers.state() == 'master'
                    and code_test(result.status_code)):
                result.set_cookie('just_updated', 'true', max_age=5)
            return result

        if 'django_replicated.router.ReplicationRouter' in settings.DATABASE_ROUTERS:
            return wrapper
        else:
            return f
    return decorator


def is_in_manual_read_only():
    """Сервис находится в ручном read-only режиме"""

    return waffle.switch_is_active('is_readonly')
