from typing import Union

from django.conf import settings
from django.utils import timezone


def localize(datetime: Union[timezone.datetime, timezone.datetime.date]) -> timezone.datetime:
    return (
        datetime
        if isinstance(datetime, timezone.datetime) else
        timezone.datetime.combine(datetime, timezone.datetime.min.time())
    ).astimezone(settings.DEFAULT_TIMEZONE)


def today():
    return localize(timezone.now()).date()


def now():
    return localize(timezone.now())


def make_localized_datetime(date, time):
    dt = timezone.datetime.combine(date, time)
    dt = settings.DEFAULT_TIMEZONE.localize(dt)
    return dt


def localize_utc(datetime):
    """Заменяет tz на DEFAULT_TIMEZONE, время и дата при этом не меняются"""
    return settings.DEFAULT_TIMEZONE.localize(datetime.replace(tzinfo=None))
