from tvm2 import TVM2
from django.conf import settings


class NotAllTicketsException(Exception):
    pass


TVM2_DESTINATIONS = (
    settings.IDM_TVM_ID,
    settings.CONSTRUCTOR_FORM_TVM_ID,
    settings.INTRASEARCH_TVM_ID,
)


def get_tvm_client():
    return TVM2(
        client_id=settings.YAUTH_TVM2_CLIENT_ID,
        secret=settings.YAUTH_TVM2_SECRET,
        blackbox_client=settings.TVM2_BLACKBOX_CLIENT,
        allowed_clients=settings.YAUTH_TVM2_ALLOWED_CLIENT_IDS,
        destinations=TVM2_DESTINATIONS,
        disk_cache_dir=settings.YAUTH_TVM2_DISK_CACHE_DIR,
        fetch_roles_for_idm_system=settings.YAUTH_TVM2_FETCH_ROLES_FOR_IDM_SYSTEM,
        tirole_env=settings.YAUTH_TVM2_TIROLE_ENV,
        tirole_check_src=settings.YAUTH_TVM2_TIROLE_CHECK_SRC,
    )


def get_tvm_ticket(destination):
    tvm_client = get_tvm_client()
    if destination not in tvm_client.destinations:
        tvm_client.add_destinations(destination)
    tickets = tvm_client.get_service_tickets(destination)
    if destination in tickets and tickets[destination]:
        return tickets[destination]
    else:
        raise NotAllTicketsException()
