"""
Когда-нибудь запилю библиотеку из этого, мне такое часто пригождается
"""

from functools import wraps

from plan.common.utils.collection.mapping import DotAccessedDict


def wrap_in(factory):
    """
    Fabric for decorators. Needs factory callable, that
    can get iterable as only parameter. Decorator feeds yields from
    decorated generator function in this factory and returns
    resulted object.

    Helps in making generators shorter and simpler by splitting
    logic and routine.
    """
    def decorator(func):
        @wraps(func)
        def catcher(*args, **kwargs):
            return factory(func(*args, **kwargs))
        return catcher
    return decorator


wrap_in_list = wrap_in(list)
wrap_in_dict = wrap_in(dict)
wrap_in_set = wrap_in(set)

try:
    from collections import OrderedDict
    wrap_in_odict = wrap_in(OrderedDict)
except ImportError:
    pass

wrap_in_dot_dict = wrap_in(DotAccessedDict)
