import datetime
import mimetypes

import xlwt

from django.http import HttpResponse


XLS_MIMETYPE = 'application/vnd.ms-excel'


def write_rows_xls(rows, out, sheet_name='Книга'):
    wb = xlwt.Workbook()
    ws = wb.add_sheet(sheet_name)
    date_style = xlwt.XFStyle()
    date_style.num_format_str = 'D.M.YY h:mm'

    for i, row in enumerate(rows):
        for j, col in enumerate(row):
            if isinstance(col, (datetime.date, datetime.datetime)):
                ws.write(i, j, col, date_style)
            else:
                ws.write(i, j, col)
    wb.save(out)


def make_attachment_response(data, filename):
    mime_type, encoding_ = mimetypes.guess_type(filename)
    response = HttpResponse(data, content_type=mime_type)
    response['Content-Disposition'] = 'attachment; filename=%s' % filename
    return response
