import json

from django.http import HttpResponseNotFound

from rest_framework.views import APIView
from rest_framework.permissions import IsAuthenticated

from plan.common.utils.rest_fw import plan_response
from plan.services.api.team import PersonSerializer
from plan.hacks.context_processors import werewolf_context


class ReadOnly(APIView):
    """
    Отдельная ручка для проверки ридонливости сервиса (или отдельных его
    страниц). Можно дергать как из ноды, так и периодически с фронтенда, чтобы
    заметить, что сервис ушел в ридонли и несохраненные данные ОПАСНОСТЕ.

    """
    permission_classes = (IsAuthenticated,)

    def get(self, request, *args, **kwargs):
        # TODO: проверять присланный path (или какой-то иной идентификатор
        # страницы) и на его основе проверять действительно ли нужно на этой
        # странице показывать readonly-сообщение либо она не зависит от баз.
        return plan_response({
            'status': bool(getattr(request, 'service_is_readonly', False))
        })


class UserView(APIView):
    permission_classes = (IsAuthenticated, )

    def get(self, request, *args, **kwargs):
        person = request.user.staff
        serializer = PersonSerializer(person)
        return plan_response({'person': serializer.data})


class WerewolfView(APIView):
    """
    Если пользователь кем-то прикидывается, то отдается тот кем он
    прикидывается.
    """
    permission_classes = (IsAuthenticated, )

    def get(self, request, *args, **kwargs):
        return plan_response(werewolf_context(request))


def handler404(request, *args, **kwargs):
    return HttpResponseNotFound(
        content=json.dumps(
            {
                'content': {},
                'error': {
                    'message': 'Url not found',
                },
            }
        )
    )
