import logging

from plan.contacts.helpers import get_url_helper
from plan.exceptions import ContactError
from plan.services.models import Service

logger = logging.getLogger(__name__)


class ContactsController(object):

    MODEL_CONTACT_FIELD_MAP = {
        Service: 'service',
    }

    def __init__(self, obj):
        self.obj = obj

    def normalize(self, params):
        if params.get('contact_type'):
            contact_type_validator = params['contact_type'].validator
        else:
            contact_type_validator = 'OTHER'

        try:
            content = params['content']
            url_helper = get_url_helper(contact_type_validator)
            params['content'] = url_helper.normalize(content)

        except UnicodeError:
            logger.exception('Contact normalization error')
            raise ContactError
