from django import forms
from plan.services.models import Service


def get_form(model_name, action):
    from plan.services.models import ServiceContact
    model = {
        'service': ServiceContact,
    }[model_name]

    class ContactAddForm(forms.Form):
        content = forms.CharField()
        title = forms.CharField(required=False)

    class ContactEditForm(forms.Form):
        contact = forms.ModelChoiceField(queryset=model.objects.all())
        content = forms.CharField()
        title = forms.CharField(required=False)

    class ContactRemoveForm(forms.Form):
        contact = forms.ModelChoiceField(queryset=model.objects.all())

    return {
        'add': ContactAddForm,
        'edit': ContactEditForm,
        'remove': ContactRemoveForm,
    }[action]


class ServiceForm(forms.Form):
    service = forms.ModelChoiceField(
        queryset=Service.objects.alive(),
        required=False,
    )
