import re

from django.core.management.base import BaseCommand

from plan.services.models import ServiceContact


PREFIX = 'https://st.yandex-team.ru/filters'
OLD_QUERY_PREFIX = '?query='
NEW_QUERY_PREFIX = '?_q='
GROUPED_QUERY_PREFIX = '?_g=%s&_q='
ORDERING_QUERY_PREFIX = '?_o=%s+%s&_q='
FILTERS = 'filters/filter'
GROUPING_RE = re.compile(r'filters/grouping:\w+/filter', re.IGNORECASE)
ORDERING_RE = re.compile(r'filters/order:\w+(:\w+)?/filter', re.IGNORECASE)
ISSUES = 'issues'
DIRECTION = {
    True: 'ASC',
    False: 'DESC',
}


def is_problem_url(content):
    return content.startswith(PREFIX) and OLD_QUERY_PREFIX in content


def change_url(url):
    g_search = GROUPING_RE.search(url)
    o_search = ORDERING_RE.search(url)
    if g_search:
        group_param = g_search.group().split(':')[1].split('/')[0]
        prefix = GROUPED_QUERY_PREFIX % group_param
        return GROUPING_RE.sub(ISSUES, url).replace(OLD_QUERY_PREFIX, prefix)
    elif o_search:
        ordering_params = o_search.group().split('/')[1].split(':')
        value = ordering_params[1]
        direction = DIRECTION[len(ordering_params) < 3 or ordering_params[2] == 'true']
        prefix = ORDERING_QUERY_PREFIX % (value, direction)
        return ORDERING_RE.sub(ISSUES, url).replace(OLD_QUERY_PREFIX, prefix)
    else:
        return url.replace(FILTERS, ISSUES).replace(OLD_QUERY_PREFIX, NEW_QUERY_PREFIX)


class Command(BaseCommand):
    def handle(self, *args, **options):
        for contact_id, content in ServiceContact.objects.values_list('id', 'content'):
            if content and is_problem_url(content):
                new_content = change_url(content)
                ServiceContact.objects.filter(id=contact_id).update(content=new_content)
