# flake8: noqa
from django.db import migrations, models


CONTACT_TYPES_LIST = [
    ('email_ml', 'MAILLIST', 'E-mail рассылка', 'Maillist'),
    ('metrika_id', 'METRIKA_ID', 'ID метрики', 'Metrika ID'),
    ('other', 'OTHER', 'Прочие ссылки', 'Other'),
    ('tracker_startrek', 'STARTREK', 'Очередь в Startrek', 'Startrek queue'),
    ('url_app', 'APP', 'Мобильное приложение', 'Mobile app'),
    ('url_at_club', 'AT_CLUB', 'Клуб в Этушке', 'Atushka'),
    ('url_beta', 'BETA', 'beta-версия', 'beta version'),
    ('url_dev', 'DEV', 'dev-версия', 'Development version'),
    ('url_doc', 'DOC', 'Документация', 'Documentation'),
    ('url_doc_instructions', 'INSTRUCTIONS', 'Каталог инструкций сервиса', 'Instructions'),
    ('url_duty_calendar', 'CALENDAR', 'Календарь дежурства', 'Duty calendar'),
    ('url_monitoring', 'MONITORING', 'Мониторинг. Основные панели сервиса/алерты', 'Monitoring'),
    ('url_sitelink', 'SITELINK', 'Адрес сервиса', 'Service url'),
    ('url_statface', 'STATFACE', 'Статистика', 'Statistics'),
    ('url_telegram', 'TELEGRAM', 'Телеграм чат', 'Telegram'),
    ('url_testing', 'TESTING', 'test-версия', 'Test version'),
    ('url_testpalm', 'TESTPALM', 'TestPalm', 'TestPalm'),
    ('url_wiki', 'WIKI', 'Вики', 'Wiki'),
    ('url_yamb', 'YAMB', 'Ямб чат', 'Yamb'),
    ('vcs', 'VCS', 'Репозиторий', 'Source code'),
]


def fill_contacttypes(apps, schema_editor):
    ContactType = apps.get_model("contacts", "ContactType")

    for code, validator, name, name_en in CONTACT_TYPES_LIST:
        ContactType.objects.create(
            code=code,
            validator=validator,
            name=name,
            name_en=name_en
        )


class Migration(migrations.Migration):

    dependencies = [
        ('contacts', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(fill_contacttypes),
    ]
