# flake8: noqa
from django.db import migrations, models

PRESENT_VALIDATORS = ['WIKI', 'MAILLIST', 'METRIKA_ID', 'AT_CLUB', 'STARTREK', 'URL']


def optimize_validators(apps, schema_editor):
    ContactType = apps.get_model('contacts', 'ContactType')

    ContactType.objects.exclude(validator__in=PRESENT_VALIDATORS).update(validator='URL')


class Migration(migrations.Migration):

    dependencies = [
        ('contacts', '0005_auto_20180326_1522'),
    ]

    operations = [
        migrations.AlterField(
            model_name='contacttype',
            name='validator',
            field=models.CharField(default='URL', max_length=50, verbose_name='\u0412\u0430\u043b\u0438\u0434\u0430\u0442\u043e\u0440'),
        ),
        migrations.RunPython(optimize_validators, reverse_code=migrations.RunPython.noop),
    ]
