# flake8: noqa
from django.db import migrations, models


def add_types(apps, schema_editor):
    ContactType = apps.get_model('contacts', 'ContactType')
    ContactType.objects.create(
        code='tracker_bugs',
        name='Баги в Startrek',
        name_en='Startrek: bugs',
        validator='ST_FILTER',
    )
    ContactType.objects.create(
        code='tracker_releases',
        name='Релизы в Startrek',
        name_en='Startrek: releases',
        validator='ST_FILTER',
    )


class Migration(migrations.Migration):

    dependencies = [
        ('contacts', '0006_auto_20180404_1140'),
    ]

    operations = [
        migrations.RunPython(add_types, reverse_code=migrations.RunPython.noop),
    ]
