from django.db import models
from django.utils.translation import ugettext_lazy as _


class ContactType(models.Model):
    code = models.CharField(verbose_name=_('Код'), max_length=50)
    validator = models.CharField(verbose_name=_('Валидатор'), max_length=50, default='URL')
    name = models.CharField(verbose_name=_('Название'), max_length=200)
    name_en = models.CharField(verbose_name=_('Название (en)'), max_length=200)
    tags = models.ManyToManyField(
        'services.ServiceTag',
        related_name='service_tags',
        verbose_name=_('Теги сервисов'),
        blank=True,
    )

    def __str__(self):
        return 'ContactType {0} ({1})'.format(
            self.code,
            self.name,
        )


class AbstractContactBase(models.Model):
    content = models.TextField(
        verbose_name=_('Контент'),
        db_index=True
    )
    type = models.ForeignKey(
        ContactType,
        verbose_name=_('Тип контакта'),
        on_delete=models.PROTECT,
        null=True, blank=True, default=None,
    )
    title = models.TextField(
        verbose_name=_('Заголовок'),
        default='',
        blank=True
    )
    title_en = models.TextField(
        verbose_name=_('Заголовок на Английском'),
        default='',
        blank=True
    )
    comment = models.CharField(
        max_length=255,
        verbose_name=_('Комментарий'),
        default='',
        blank=True
    )
    created_at = models.DateTimeField(auto_now_add=True)
    modified_at = models.DateTimeField(auto_now=True)

    class Meta:
        abstract = True
