import re

http_pattern = r'(https?:\/\/)'

# Стырил из django.core.validators.URLValidator, немного доработав
URL_RE = re.compile(
    r'^(?:http|ftp)s?://'  # http:// or https:// or ftp://
    r'(?:(?:[A-Z0-9](?:[A-Z0-9-]{0,61}[A-Z0-9])?\.)+(?:[A-Z]{2,6}\.?|[A-Z0-9-]{2,}\.?)|'  # domain...
    r'localhost|'  # localhost...
    r'\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}|'  # ...or ipv4
    r'\[?[A-F0-9]*:[A-F0-9:]+\]?)'  # ...or ipv6
    r'(?::\d+)?'  # optional port
    r'(?:/?|[/?]\S+)$',
    re.IGNORECASE,
)

# TRACKER
tracker_queue_pattern = r'(?P<queue>[a-z]+)'

QUEUE_RE = re.compile(
    r'^{0}$'.format(tracker_queue_pattern),
    re.IGNORECASE,
)
ST_RE = re.compile(
    r'^{0}?st\.yandex-team\.ru/{1}/?$'.format(
        http_pattern, tracker_queue_pattern
    ),
    re.IGNORECASE,
)
FILTER_RE = re.compile(
    r'^https://st\.yandex-team\.ru/filters/[\w/\d:]*(\?(\b(?:(?!query=).)+\b))?$',
    re.IGNORECASE,
)
FILTER_QUERY_RE = re.compile(
    r'^https://st\.yandex-team\.ru/issues/?\?.*',
    re.IGNORECASE,
)

# ML
ml_pattern = r'(?P<ml>[\w\d-]+)@?'

ML_EMAIL_RE = re.compile(
    r'^{0}@yandex-team\.ru$'.format(ml_pattern),
    re.IGNORECASE,
)
ML_RE = re.compile(
    r'^({0}?(ml|maillists)\.yandex-team\.ru/lists/)?{1}/?$'.format(
        http_pattern, ml_pattern),
    re.IGNORECASE,
)

# METRIKA
METRIKA_RE = re.compile(
    r'({0}?metrika\.yandex\.ru/stat/dashboard/?\?counter_id=)?'
    r'(?P<metrika_id>\d+)/?$'.format(http_pattern),
    re.IGNORECASE,
)

# AT
AT_CLUB_RE = re.compile(
    r'^{0}?(clubs\.)?at\.yandex-team\.ru/(?P<at_club>/?[\d\w-]+)/?$'.format(
        http_pattern),
    re.IGNORECASE,
)
AT_ONLY_CLUB_RE = re.compile(
    r'^(?P<at_club>[\d\w-]+)$',
    re.IGNORECASE,
)

# WIKI
WIKI_RE = re.compile(
    r'^{0}?(?:beta.)?wiki\.yandex-team\.ru/(?P<wiki_path>\S+?)/?$'.format(
        http_pattern),
    re.IGNORECASE | re.VERBOSE
)
WIKI_PATH_RE = re.compile(
    r'^/?(?P<wiki_path>\S+)$',
    re.IGNORECASE,
)
