from django.db.models import Q

from plan.api.exceptions import ValidationError
from plan.contacts.forms import ServiceForm
from plan.contacts.models import ContactType
from plan.lib.views.base import UniversalView


class ContactTypesView(UniversalView):

    def get(self, request, *args, **kwargs):
        form = ServiceForm(request.GET)
        if not form.is_valid():
            raise ValidationError(extra=form.errors)

        qs = ContactType.objects.all()

        service = form.cleaned_data.get('service')
        if service:
            qs = qs.filter(
                Q(tags__isnull=True) |
                Q(tags__service=service)
            )

        types = []
        for contact_type in qs:
            types.append({
                'id': contact_type.code,
                'name': contact_type.name,
            })
        return {
            'types': types
        }
