from django.db.models.signals import pre_save
from django_celery_beat.models import PeriodicTask, CrontabSchedule, IntervalSchedule


def periodic_task_pre_save(sender, instance, **kwargs):
    schedule_changed = False

    if instance.pk:
        previous = sender.objects.get(pk=instance.pk)

        if (instance.crontab_id != previous.crontab_id
                or instance.interval_id != previous.interval_id):
            schedule_changed = True

    if schedule_changed:
        instance.last_run_at = None


def schedule_pre_save(sender, instance, **kwargs):
    schedule_changed = False

    if instance.pk:
        previous = sender.objects.get(pk=instance.pk)
        for f in sender._meta.fields:
            fname = f.name
            if fname == 'id':
                continue

            if getattr(instance, fname) != getattr(previous, fname):
                schedule_changed = True
                break

    if schedule_changed:
        for task in instance.periodictask_set.all():
            task.last_run_at = None
            task.save()


pre_save.connect(
    periodic_task_pre_save,
    sender=PeriodicTask,
    dispatch_uid='django_celery_beat.PeriodicTask.pre_save'
)

pre_save.connect(
    schedule_pre_save,
    sender=CrontabSchedule,
    dispatch_uid='django_celery_beat.CrontabSchedule.pre_save'
)

pre_save.connect(
    schedule_pre_save,
    sender=IntervalSchedule,
    dispatch_uid='django_celery_beat.IntervalSchedule.pre_save'
)
