def get_model_instance(model_path, pk):
    """
    Получить из базы объект по полному имени модели и первичному ключу.
    """
    from django.apps import apps
    model_cls = apps.get_model(model_path)
    return model_cls.objects.get(pk=pk)


def get_model_path_by_cls(model_cls):
    """
    Имя модели будет в нижнем регистре.
    """
    meta = model_cls._meta
    return '.'.join([meta.app_label, meta.model_name])
