from django.conf.urls import url

from plan.departments import views


urlpatterns = [
    url(
        r'^$',
        views.DepartmentRedirectView.as_view(),
        name='department'
    ),
    url(
        r'^(?P<id>\d+)/$',
        views.DepartmentView.as_view(),
        name='department'
    ),
    url(
        r'^(?P<department_slug>\w+)/$',
        views.DepartmentView.as_view(),
        name='department'
    ),
    url(
        r'^(?P<id>\d+)/members/$',
        views.DepartmentMembersView.as_view(),
        name='members'
    ),
]
