from django.core.urlresolvers import reverse

from plan.exceptions import HttpRedirect
from plan.lib.views.base import UniversalView


class DepartmentRedirectView(UniversalView):
    def get(self, request):
        department_id = request.user.staff.department_id
        raise HttpRedirect(reverse(
            viewname='departments:department',
            kwargs={'id': department_id},
        ))
