from django.contrib import admin

from plan.common.base_admin import ViewModelAdmin
from plan.duty import models


@admin.register(models.Schedule)
class ScheduleAdmin(ViewModelAdmin):
    list_display = ('service', 'name', 'role',)
    search_fields = ('name', 'service__slug', 'service__name')


@admin.register(models.Shift)
class ShiftAdmin(ViewModelAdmin):
    date_hierarchy = 'start_datetime'
    list_display = (
        'staff',
        'schedule',
        'start',
        'end',
        'is_approved',
        'has_problems',
    )

    list_filter = ('state', )
    search_fields = (
        'schedule__name',
        'schedule__slug',
        'schedule__service__slug',
        'staff__login',
    )


@admin.register(models.Problem)
class ProblemAdmin(ViewModelAdmin):
    list_display = ('shift', 'schedule', 'staff', 'reason')
    date_hierarchy = 'report_date'


@admin.register(models.DutyToWatcher)
class DutyToWatcherAdmin(ViewModelAdmin):
    list_display = ('abc_id', 'watcher_id')
