from rest_framework.metadata import BaseMetadata

from plan.duty.permissions import can_modify_shift


class ShiftMetadata(BaseMetadata):
    def determine_metadata(self, request, view):
        view_permissions = []

        try:
            shift = view.get_object()
            if can_modify_shift(request.person, shift):
                view_permissions.append('can_modify_shift')

        except AssertionError:  # выскочит если вызывают там, где нет инстанса
            pass

        return {'permissions': view_permissions}
