import logging

from django.core.management.base import BaseCommand
from django.db import connection
from django.db.models import Q

from plan.duty.models import Shift

log = logging.getLogger(__name__)

UPDATE_QUERY = '''
UPDATE duty_shift
SET start_datetime = cast("start" as timestamp with time zone),
    end_datetime = cast("end" as timestamp with time zone) + interval '1 day'
WHERE id IN (SELECT id
             FROM duty_shift
             WHERE start_datetime is NULL
             OR end_datetime is NULL
             LIMIT 2000)
'''


class Command(BaseCommand):
    def handle(self, *args, **options):
        log.info('Start fill type in serviserosources')
        filter_query = Q(start_datetime__isnull=True) | Q(end_datetime__isnull=True)
        total_count = Shift.objects.filter(filter_query).count()
        updated_count = 0
        with connection.cursor() as cursor:
            while True:
                cursor.execute(UPDATE_QUERY)
                if not cursor.rowcount:
                    break
                updated_count += cursor.rowcount
                log.info('Updated %s shifts from %s', updated_count, total_count)
            log.info('Fill datetime fields in shifts finished, updated %s from %s', updated_count, total_count)
