import logging

from django.core.management.base import BaseCommand

from plan.duty.models import Schedule
from plan.services.models import Service

log = logging.getLogger(__name__)


class Command(BaseCommand):
    def handle(self, *args, **options):
        scheduled_services = Schedule.objects.active().values_list('service', flat=True).distinct()

        for service_id in scheduled_services:
            service = Service.objects.get(pk=service_id)

            responsible_for_duty = list(service.members.responsible_for_duty().active().select_related('staff'))
            if len(responsible_for_duty) == 0:
                responsible_for_duty = list(service.members.responsibles().active().select_related('staff'))

            if len(responsible_for_duty) > 0:
                print("((%s https://abc.yandex-team.ru/services/%s))." % (service.name, service.id), end=' ')
                for responsible in responsible_for_duty:
                    print("staff:%s" % responsible.staff.login, end=' ')
                print("")
