# flake8: noqa
from django.db import migrations


def copy_fields(apps, schema):
    Calendar = apps.get_model('duty', 'Calendar')
    for calendar in Calendar.objects.all():
        calendar.schedules.update(
            duration=calendar.duration,
            service=calendar.service,
            start_date=calendar.start_date,
        )


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0074_servicenotification'),
        ('duty', '0021_moving_fields_from_calendar_to_schedule'),
    ]

    operations = [
        migrations.RunPython(code=copy_fields, reverse_code=lambda *args: None)
    ]
