# flake8: noqa
# Generated by Django 1.10.8 on 2019-06-11 10:59


from django.db import migrations, models
import django.db.models.deletion


def fill_staff(apps, schema):
    Order = apps.get_model('duty', 'Order')
    for order in Order.objects.all():
        order.staff = order.member.staff
        order.save(update_fields=['staff'])


class Migration(migrations.Migration):

    dependencies = [
        ('staff', '0001_initial'),
        ('duty', '0024_schedule_change_unique_together'),
    ]

    operations = [
        migrations.AddField(
            model_name='order',
            name='staff',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='orders', to='staff.Staff', verbose_name='\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c'),
        ),
        migrations.AddField(
            model_name='schedule',
            name='manual_ordering_offset',
            field=models.IntegerField(default=0, verbose_name='\u0421\u0434\u0432\u0438\u0433 \u043f\u0440\u0438 \u0440\u0430\u0441\u0447\u0435\u0442\u0435 \u0434\u0435\u0436\u0443\u0440\u043d\u043e\u0433\u043e'),
        ),
        migrations.AddField(
            model_name='shift',
            name='index',
            field=models.IntegerField(null=True, verbose_name='\u0418\u043d\u0434\u0435\u043a\u0441'),
        ),
        migrations.AlterUniqueTogether(
            name='order',
            unique_together=set([('schedule', 'staff')]),
        ),
        migrations.RunPython(code=fill_staff, reverse_code=lambda apps, schema: None)
    ]
