# flake8: noqa
# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2020-02-28 13:24
from __future__ import unicode_literals

import datetime
from django.db import migrations, models


def update_start_time(apps, schema_editor):
    Schedule = apps.get_model('duty', 'Schedule')
    schedules = Schedule.objects.all()
    schedules.update(start_time=datetime.time(0, 0))


class Migration(migrations.Migration):

    dependencies = [
        ('duty', '0039_change_schedule_default_start_time'),
    ]

    operations = [
        migrations.AlterField(
            model_name='schedule',
            name='start_time',
            field=models.TimeField(default=datetime.time(0, 0), verbose_name='Время начала по Москве'),
        ),
        migrations.RunPython(update_start_time, reverse_code=migrations.RunPython.noop),
    ]
