# flake8: noqa
# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-07-30 17:51
from __future__ import unicode_literals

from django.db import migrations

from plan.api.idm.actions import deprive_role
from plan.idm.exceptions import IDMError


def cleanup_inactive_schedules(apps, schema_editor):
    Schedule = apps.get_model('duty', 'Schedule')
    for schedule in Schedule.objects.filter(service=None):
        shifts = schedule.shifts.started().select_related('member')
        for shift in shifts:
            try:
                deprive_role(shift.member)
            except IDMError:
                pass
            shift.delete()
        schedule.delete()


def undo(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('roles', '0008_fake_py3_migration'),
        ('duty', '0051_auto_20200720_1520'),
    ]

    operations = [
        migrations.RunPython(cleanup_inactive_schedules, undo),
    ]
