# flake8: noqa
# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-07-28 13:59
from __future__ import unicode_literals

from django.db import migrations
from django.db.models import Subquery, OuterRef
from django.db.models.functions import Coalesce


def populate_shift_role(apps, schema_editor):
    Schedule = apps.get_model('duty', 'Schedule')
    Shift = apps.get_model('duty', 'Shift')
    Role = apps.get_model('roles', 'Role')

    duty_role = Role.objects.get(code='duty')
    Shift.objects.filter(
        role=None
    ).update(
        role=Coalesce(
            Subquery(Schedule.objects.filter(shifts__id=OuterRef('pk')).values('role_on_duty')[:1]),
            duty_role.id,
        )
    )


def undo(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('duty', '0053_remove_member_add_role'),
    ]

    operations = [
        migrations.RunPython(populate_shift_role, undo),
    ]
