# flake8: noqa
# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models

from plan.common.utils import timezone


def set_deleted_at(apps, schema_editor):
    Schedule = apps.get_model('duty', 'Schedule')
    Schedule.objects.filter(status='deleted').update(deleted_at=timezone.now())


def undo(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('duty', '0057_schedule_deleted_at'),
    ]

    operations = [
        migrations.RunPython(set_deleted_at, undo)
    ]
