# flake8: noqa
# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-12-08 15:49
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


def only_workday(apps, schema):
    Schedule = apps.get_model('duty', 'Schedule')
    for schedule in Schedule.objects.all():
        schedule.duty_on_holidays = not schedule.only_workdays
        schedule.duty_on_weekends = not schedule.only_workdays
        schedule.save(update_fields=['duty_on_holidays', 'duty_on_weekends'])


class Migration(migrations.Migration):

    dependencies = [
        ('duty', '0062_auto_20201202_1840'),
    ]

    operations = [
        migrations.AddField(
            model_name='schedule',
            name='duty_on_holidays',
            field=models.BooleanField(default=True, verbose_name='Дежурить по праздникам'),
        ),
        migrations.AddField(
            model_name='schedule',
            name='duty_on_weekends',
            field=models.BooleanField(default=True, verbose_name='Дежурить по выходным'),
        ),
        migrations.AlterField(
            model_name='shift',
            name='approve_datetime',
            field=models.DateTimeField(blank=True, null=True, verbose_name='Время подтверждения'),
        ),
        migrations.AlterField(
            model_name='shift',
            name='approved_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='staff.Staff', verbose_name='Кем подтверждено'),
        ),
        migrations.RunPython(code=only_workday, reverse_code=lambda apps, schema: None)
    ]
