from django.conf import settings

from plan.common.utils.http import Session
from plan.common.utils.timezone import localize_utc

WORKFLOW_LIST = [
    'absence',
    'illness',
    'learning',
    'maternity',
    'vacation',
    'trip',
    'conference_trip',
    'paid_day_off',
    'conference',
    # no duty!
]

STATES_LIST = [
    'new',
    'signed',
    'confirmed',
]


def get_gaps(logins, start, end):
    assert start <= end

    with Session(oauth_token=settings.OAUTH_ROBOT_TOKEN) as session:
        gaps = []
        page = 0
        pages = 1
        while page < pages:
            result = session.get(
                settings.GAP_API_URL,
                params={
                    'person_login': logins,
                    'date_from': start,
                    'date_to': end,
                    'page': page,
                    'state': STATES_LIST,
                    'workflow': WORKFLOW_LIST,
                }
            ).json()
            gaps += result['gaps']
            pages = result['pages']
            page += 1
        return gaps


def gap_localize(gaps):
    for gap in gaps:
        if gap['full_day']:
            gap['start'] = localize_utc(gap['start'])
            gap['end'] = localize_utc(gap['end'])

    return gaps
