#!/usr/bin/env python
import os
import sys


def setup_env():
    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'plan.settings')
    # форсируем загрузку настроек
    from django.conf import settings
    settings.LOGGING
    from . import celery_app  # noqa: F401


def django_manage():
    setup_env()
    from django.core.management import execute_from_command_line
    execute_from_command_line(sys.argv)


def celery_manage():
    setup_env()
    from celery.bin.celery import main
    return main()


if __name__ == '__main__':
    django_manage()
